import matplotlib.pyplot as plt
import numpy as np
import subfunctions as sf
from scipy.optimize import root_scalar

rover = {'wheel_assembly': {'wheel': {'radius': 0.3, 'mass': 1},
                            'speed_reducer': {'type': 'reverted', 'diam_pinion': 0.05, 'diam_gear': 0.08, 'mass': 1.50},
                            'motor': {'torque_stall': 175, 'torque_noload': 0, 'speed_noload': 3.9, 'mass': 5}},
         'chassis': {'mass': 659}, 'science_payload': {'mass': 75}, 'power_subsys': {'mass': 90}}
planet = {'g': 3.72}

angle = 0
crr_array = np.linspace(0.01, 0.5, 25)
v_max = []
for i in range(len(crr_array)):
    crr = crr_array[i]
    fx = lambda x: sf.F_net(x, angle, rover, planet, crr)
    ans = root_scalar(fx, method='bisect', bracket=[-1,4])
    w_max = ans.root
    r = rover['wheel_assembly']['wheel']['radius']
    v_max_value = r * w_max
    v_max.append(v_max_value)

plt.plot(crr_array, v_max)
plt.title('Rolling Resistance Analysis')
plt.xlabel('Crr')
plt.ylabel('Maximum Velocity (m/s)')
plt.show()
